	function [G, Z, P] = L_PHASE_LATTICE_WDF(WcT, WsT, Amax, Amin, phError, N)
 
	% 	Computes the poles and zeros of an odd-order lattice filter with 
	%	approximately linear phase, exept for the M poles at z = 0.
	%	The filter consists of an allpass filter in parallel with 
	%	M = (N-1)/2 delays. The order of the allpass filter is M+1.
	% 	Uses the algorithm of M. Renfors and T. Saramaki, ISCAS 1986.
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Hakan Johansson 1996-05-04
	% 	Modified by: 	LW 2010-12-17
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1	
	% 	Known bugs:	 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	% Initialization
	M1 = (N-1)/2;	
	points = 20; range = points*180;	
	Wp = points*36;
	Ws = points*72;
	Amax = min([Amax, -20*log10(cos(phError))]);
	dp = 1 - 10^(-Amax/20);
	ds = 10^(-Amin/20);
	M2 = M1+1; Q = 2; h = 0; f = 0; ftemp = 0; first = 0; 
	second = 0; De = 0; DeNorm = 0; delta = 0; W = 0; G = 0; 
	D = 0; d = 0; check = 0;
	
	% Initial M2+1 extremal points
	if check == 0
		w = 0;
		Np = round((M2+1)*WcT/(WcT+pi-WsT));
		Ns = M2+1-Np;
		N = Np+Ns;
		w(1:Np) = WcT/Np:WcT/Np:WcT;
		w(Np+1:N) = WsT:(pi-WsT)/Ns:pi-((pi-WsT)/Ns);
	end
	Q = 1;
	while Q > 0	
		% Weighting function
		for n = 1:Np
			W(n) = 1/(2*acos(1-(dp))); % W(n) = 1/(phError);
		end
		for n = Np+1:N
			W(n) = 1/(2*asin(ds)); % W(n) = 1/(phError);
		end
		% Desired function
		De(1:Np) = -M1*w(1:Np);
		De(Np+1:N) = -M1*w(Np+1:N)-pi;
		d(1) = 0;
		for k = 1:M2+1
			delta(k) = (-1)^(Np-1)*d(1)*(-1)^k;
		end;
		Fi = De + delta./W;
		num = Polynomial_1(Fi(1:N-1),w(1:N-1),1,M2);
		num = num/num(length(num));
		den = num;
		len = length(num);
		for n = 2:2:len
			den(len-n+1) = -num(len-n+1);
		end
		[numd dend] = bilinear(num,den,0.5);
		wT = w(N)/180:w(N)/180:w(N);
		[FiTemp,wT] = freqz(numd,dend,wT);
		FiTemp = unwrap(angle(FiTemp));
		G(1) = W(N)*(FiTemp(length(FiTemp))-De(N))-delta(N);
		
		d(2) = d(1)+0.01;
		for k = 1:M2+1
			delta(k) = (-1)^(Np-1)*d(2)*(-1)^k;
		end;
		Fi = De+delta./W;
		num = Polynomial_1(Fi(1:N-1),w(1:N-1),1,M2);
		num = num/num(length(num));
		den = num;
		len = length(num);
		for n = 2:2:len
			den(len-n+1) = -num(len-n+1);
		end
		[numd dend] = bilinear(num,den,0.5);
		wT = w(N)/180:w(N)/180:w(N);
		[FiTemp,wT] = freqz(numd,dend,wT);
		FiTemp = unwrap(angle(FiTemp));
		G(2) = W(N)*(FiTemp(length(FiTemp))-De(N))-delta(N);
		while sign(G(2)) == sign(G(1))
			d(1) = d(2);
			d(2) = d(2)+0.01;
			for k = 1:M2+1
				delta(k) = (-1)^(Np-1)*d(2)*(-1)^k;
			end;
			Fi = De+delta./W;
			num = Polynomial_1(Fi(1:N-1),w(1:N-1),1,M2);
			num = num/num(length(num));
			den = num;
			len = length(num);
			for n = 2:2:len
				den(len-n+1) = -num(len-n+1);
			end
			[numd dend] = bilinear(num,den,0.5);
			wT = w(N)/180:w(N)/180:w(N);
			[FiTemp,wT] = freqz(numd,dend,wT);
			FiTemp = unwrap(angle(FiTemp));
			G(1) = G(2);
			G(2) = W(N)*(FiTemp(length(FiTemp))-De(N))-delta(N);
		end;
		G(3) = G(2); d(3) = d(2);		
		while abs(G(3)) > 0.001
			%d(3) = 0.5*(d(1)+d(2));
			for k = 1:M2+1
				delta(k) = (-1)^(Np-1)*d(3)*(-1)^k;
			end;
			Fi = De+delta./W;
			num = Polynomial_1(Fi(1:N-1),w(1:N-1),1,M2);
			num = num/num(length(num));
			den = num;
			len = length(num);
			for n = 2:2:len
				den(len-n+1) = -num(len-n+1);
			end
			[numd dend] = bilinear(num,den,0.5);
			wT = w(N)/180:w(N)/180:w(N);
			[FiTemp,wT] = freqz(numd,dend,wT);
			FiTemp = unwrap(angle(FiTemp));
			%G(2) = G(3);
			G(3) = W(N)*(FiTemp(length(FiTemp))-De(N))-delta(N);
			if (G(3) > 0 & G(2) > 0)|(G(3) < 0 & G(2) < 0)
				d(2) = d(3);
				G(2) = G(3);
			else
				d(1) = d(3);
			end
			d(3) = 0.5*(d(1)+d(2));
		end 
		N1 = 0;	N1(M2) = 1; D1 = 1; D1(M2) = 0;
		numdTemp = conv(N1,dend) + conv(numd,D1);
		dendTemp = conv(dend,D1);
		[H,wT] = freqz(numdTemp,dendTemp,points*360,'whole');	
		Mag = abs(H)/max(abs(H(1)));
		e = exp(1); E = 0;
		[FiTemp,wT] = freqz(numd,dend,360*points,'whole');
		FiTemp = unwrap(angle(FiTemp));
		E(1:Wp+1) = W(1)*(FiTemp(1:Wp+1)+M1*(wT(1:Wp+1)));
		E(Ws+1:180*points+1) = W(N)*(FiTemp(Ws+1:180*points+1)-(-M1*(wT(Ws+1:180*points+1))-pi));
		%		figure(1)
		%		plot(E);
		E2 = E;
		
		% Find the M2+1 extremal points of E
		E = abs(E);
		wl = 0;
		index = 1;
		for n = 1:Wp-2,
			if (E(n+2) <= E(n+1)) & (E(n) <= E(n+1)),
				wl(index) = n+1;
				index = index+1;
			end
		end
		for n = Ws+1:points*180-2,
			if (E(n+2) <= E(n+1)) & (E(n) <= E(n+1)),
				wl(index) = n+1;
				index = index+1;
			end
		end
		if length(wl) > M2-1
			minind = 1;
			if E(wl(length(wl))) <= E(wl(minind))
				minind = length(wl);
			end
			wl(minind) = Wp+1;
			wl(length(wl)+1) = Ws+1;
		else
			wl(length(wl)+1) = Wp+1;
			wl(length(wl)+1) = Ws+1;
		end
		wl = sort(wl);
		Np = 0;
		for k = 1:M2+1
			if wl(k) <= Wp+1
				Np = Np+1;
			end
		end
		Ns = M2+1-Np;	
		wl = 2*pi*(wl-1)./(points*360);
		Qtemp = 0;
		for k = 1:N
			if abs(wl(k)-w(k)) > 0.001
				Qtemp = 1;
			end
		end
		if Qtemp > 0
			w = wl; % ==
		else
			Q = 0;
		end
	end
	P = cplxpair(roots(dend));
	Z = 1./P;
	G = 1;
%	Z = cplxpair(roots(num));
	%	x = 0:range;
	%	xf = 0:Wp;
	%	dpp = 1-min(Mag(1:points*72+1));
	%	G2 = 1/(1-dpp)^2-1;
	%	k = (1/(1-dp)^2-1)/G2;
	%	G2 = 1/ds/ds/d(1)/d(1)-1;
	%	dss = sqrt(1/(1+k*G2));
	
	%	dss = max(Mag(points*108+1:points*180+1));
	%	G2 = 1/dss/dss-1;
	%	k = (1/ds/ds-1)/G2;
	%	dpp = 1-min(Mag(1:points*72+1));
	%	G2 = 1/(1-dpp)^2-1;
	%	dp = 1-sqrt(1/(1+k*G2)) 

	function P = Polynomial_1(Psi, w, N, R)
	%
	% Private function for LINEAR_PHASE_LATTICE_WDF
	%
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Hakan Johansson 1996-05-04
	% 	Modified by: 	
	% 	Copyright:		Divison of Electronics Systems
	% 					Dept. Electrical Engineering, Linkoping University, Sweden
	% 	Version:		
	% 	Known bugs:	 
	% 	Report bugs to:	larsw@isy.liu.se
	
	W = 0; B = 0; D = 0; P = 0; P1 = 0; P2 = 0; P3 = 0;
	for index = 1:length(w),
		W(index) = tan(N*w(index)/2);
	end
	% Calculate the parameters B
	B(1) = tan(Psi(1)/2)/W(1);
	if R > 1
		B(2) = (1-B(1)*W(2)/tan(Psi(2)/2))/(W(2)*W(2)-W(1)*W(1));
	end
	if R > 2,
		for r = 3:R,
			D = tan(Psi(r)/2);
			for k = 1:r-2,
				if k == 1,
					D = 1-B(1)*W(r)/D;
				else
					D = 1-B(k)*(W(r)*W(r)-W(k-1)*W(k-1))/D;
				end
			end
			B(r) = (1-B(r-1)*(W(r)*W(r)-W(r-2)*W(r-2))/D)/(W(r)*W(r)-W(r-1)*W(r-1));
		end
	end

	% Calculate the polynomial P(s)
	P1 = 1;
	P2 = [1 B(1)];
	if R > 1
		for r = 2:R,
			P3 = P2;
			P3(length(P2)+1) = 0;
			for index = 1:length(P1)
				P3(index) = P3(index)+B(r)*W(r-1)*W(r-1)*P1(index);
			end
			for index = 3:length(P1)+2,
				P3(index) = P3(index)+B(r)*P1(index-2);
			end
			P1 = P2;
			P2 = P3;
		end
		for k = 1:length(P3),
			P(length(P3)-k+1) = P3(k);
		end
	else
		P = [B(1) 1];
	end
